<?php
/* --------------------------------------------------------------
 Configurations.php 2019-10-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Read\Collections;

use Gambio\Core\Configuration\Models\Read\ConfigurationGroupItem;
use JsonSerializable;

/**
 * Class Configurations
 * @package Gambio\Core\Configuration\Models\Collections
 */
class ConfigurationGroup implements JsonSerializable
{
    /**
     * @var ConfigurationGroupItem[]
     */
    private $configurations;
    
    
    /**
     * Configurations constructor.
     *
     * @param ConfigurationGroupItem[] $configurations
     */
    private function __construct(ConfigurationGroupItem ...$configurations)
    {
        $this->configurations = $configurations;
    }
    
    
    /**
     * Factory method for Configurations.
     *
     * @param ConfigurationGroupItem[] $configurations
     *
     * @return static
     */
    public static function create(ConfigurationGroupItem ...$configurations): self
    {
        return new static(...$configurations);
    }
    
    
    /**
     * Json serialization.
     */
    public function jsonSerialize(): array
    {
        $data = [];
        foreach ($this->configurations as $configuration) {
            $data[] = $configuration->toArray();
        }
        
        return $data;
    }
}